/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HscResourceId;
import com.ibm.hsc.rep.RClassSchema;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.RUtils;
import java.util.Enumeration;
import java.util.Vector;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;

public class HscIdUtils {
    private static HscIdUtils mInst = null;

    public static HscIdUtils getInstance() {
        if (mInst == null) {
            mInst = new HscIdUtils();
        }
        return mInst;
    }

    public HscResourceId createHscResourceId(RObjectId rObjectId, int n) throws RException {
        int n2 = rObjectId.getNameSpaceId();
        int n3 = rObjectId.getClassId();
        RClassSchema rClassSchema = RUtils.getClassSchema(n2, n3);
        String string = RUtils.getNameSpaceString(n2);
        String string2 = rClassSchema.getClassName();
        HscResourceId hscResourceId = new HscResourceId(string, string2, n);
        int n4 = rObjectId.getNumOfKeys();
        for (int i = 0; i < n4; ++i) {
            int n5 = rClassSchema.getKeyPos(i);
            String string3 = rClassSchema.getPropName(n5);
            hscResourceId.setKeyValue(string3, rObjectId.getKeyValue(i));
        }
        return hscResourceId;
    }

    public HscResourceId createHscResourceId(CIMObjectPath cIMObjectPath, int n) {
        String string = cIMObjectPath.getNameSpace();
        String string2 = cIMObjectPath.getObjectName();
        HscResourceId hscResourceId = new HscResourceId(string, string2, n);
        Vector vector = cIMObjectPath.getKeys();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                hscResourceId.setKeyValue(cIMProperty.getName(), cIMProperty.getValue().getValue());
            }
        }
        return hscResourceId;
    }

    public RObjectId createRObjectId(HscResourceId hscResourceId) throws RException {
        int n = RUtils.getNameSpaceId(hscResourceId.getNameSpace());
        int n2 = RUtils.getClassId(n, hscResourceId.getClassName());
        RClassSchema rClassSchema = RUtils.getClassSchema(n, n2);
        RObjectId rObjectId = new RObjectId(n, n2);
        int n3 = rClassSchema.getNumOfKeys();
        for (int i = 0; i < n3; ++i) {
            int n4 = rClassSchema.getKeyPos(i);
            String string = rClassSchema.getPropName(n4);
            rObjectId.setKeyValue(i, hscResourceId.getKeyValue(string));
        }
        return rObjectId;
    }
}

